<?php

/**
 * Test cases for the AlphaDAOProviderFactory class.
 *
 * @package alpha::tests
 * @since 1.2.1
 * @author John Collins <dev@alphaframework.org>
 * @version $Id: AlphaDAOProviderFactory_Test.php 1612 2012-12-18 12:16:22Z alphadevx $
 * @license http://www.opensource.org/licenses/bsd-license.php The BSD License
 * @copyright Copyright (c) 2012, John Collins (founder of Alpha Framework).
 * All rights reserved.
 *
 * <pre>
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 *
 * * Redistributions of source code must retain the above
 *   copyright notice, this list of conditions and the
 *   following disclaimer.
 * * Redistributions in binary form must reproduce the above
 *   copyright notice, this list of conditions and the
 *   following disclaimer in the documentation and/or other
 *   materials provided with the distribution.
 * * Neither the name of the Alpha Framework nor the names
 *   of its contributors may be used to endorse or promote
 *   products derived from this software without specific
 *   prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * </pre>
 *
 */
class AlphaDAOProviderFactory_Test extends PHPUnit_Framework_TestCase {

    /**
     * Testing the getInstance() method with good parameters
     *
     * @since 1.2.1
     */
    public function testGetInstanceGood() {
        $provider = AlphaDAOProviderFactory::getInstance('AlphaDAOProviderSQLite', new PersonObject());

        $this->assertTrue($provider instanceof AlphaDAOProviderInterface, 'testing the getInstance() method with good parameters');
        $this->assertTrue($provider instanceof AlphaDAOProviderSQLite, 'testing the getInstance() method with good parameters');
    }

    /**
     * Testing the getInstance() method with bad parameters
     *
     * @since 1.2.1
     */
    public function testGetInstanceBad() {

        try {
            $provider = AlphaDAOProviderFactory::getInstance('AlphaDAOProviderDoesNotExist', new PersonObject());
            $this->fail('testing the getInstance() method with bad parameters');
        }catch (IllegalArguementException $e) {
            $this->assertEquals('The class [AlphaDAOProviderDoesNotExist] is not defined anywhere!', $e->getMessage(), 'testing the getInstance() method with bad parameters');
        }

        try {
            $provider = AlphaDAOProviderFactory::getInstance('AlphaDAOProviderFactory', new PersonObject());
            $this->fail('testing the getInstance() method with bad parameters');
        }catch (IllegalArguementException $e) {
            $this->assertEquals('The class [AlphaDAOProviderFactory] does not implement the expected AlphaDAOProviderInterface interface!', $e->getMessage(), 'testing the getInstance() method with bad parameters');
        }
    }
}

?>