<?php

/**
 *
 * A filter class for filtering user input from text fields
 * 
 * @package alpha::util
 * @since 1.0
 * @author John Collins <dev@alphaframework.org>
 * @version $Id: InputFilter.inc 1693 2013-12-09 23:33:24Z alphadevx $
 * @license http://www.opensource.org/licenses/bsd-license.php The BSD License
 * @copyright Copyright (c) 2012, John Collins (founder of Alpha Framework).  
 * All rights reserved.
 * 
 * <pre>
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the 
 * following conditions are met:
 * 
 * * Redistributions of source code must retain the above 
 *   copyright notice, this list of conditions and the 
 *   following disclaimer.
 * * Redistributions in binary form must reproduce the above 
 *   copyright notice, this list of conditions and the 
 *   following disclaimer in the documentation and/or other 
 *   materials provided with the distribution.
 * * Neither the name of the Alpha Framework nor the names 
 *   of its contributors may be used to endorse or promote 
 *   products derived from this software without specific 
 *   prior written permission.
 *   
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * </pre>
 *  
 */
class InputFilter {
	/**
	 * The encoding method which applies the filters
	 * 
	 * @param string $text
	 * @param boolean $allowHTML
	 * @return string
	 * @since 1.0
	 */
	public static function encode($text, $allowHTML=false) {
		if(!get_magic_quotes_gpc()) {
			if($allowHTML)
				return $text;
			else
				return htmlentities($text, ENT_COMPAT, 'utf-8');
		}else{
			if($allowHTML)
				return $text;
			else
				return htmlentities($text, ENT_COMPAT, 'utf-8');
		}
	}
	
	/**
	 * The decoding method which reverses the filters
	 * 
	 * @param string $text
	 * @param boolean $allowHTML
	 * @return string
	 * @since 1.0
	 */
	public static function decode($text, $allowHTML=false) {
		if(!get_magic_quotes_gpc())
			if($allowHTML)		
				return $text;
			else
				return html_entity_decode($text);
		else
			if($allowHTML)
				return $text;
			else
				return html_entity_decode($text);
	}
}

?>