<?php

/**
 * Class for blocking requests from blacklisted IP addresses
 *
 * @package alpha::util::filters
 * @since 1.2
 * @author John Collins <dev@alphaframework.org>
 * @version $Id: IPBlacklistFilter.inc 1574 2012-10-23 14:06:12Z alphadevx $
 * @license http://www.opensource.org/licenses/bsd-license.php The BSD License
 * @copyright Copyright (c) 2012, John Collins (founder of Alpha Framework).
 * All rights reserved.
 *
 * <pre>
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 *
 * * Redistributions of source code must retain the above
 *   copyright notice, this list of conditions and the
 *   following disclaimer.
 * * Redistributions in binary form must reproduce the above
 *   copyright notice, this list of conditions and the
 *   following disclaimer in the documentation and/or other
 *   materials provided with the distribution.
 * * Neither the name of the Alpha Framework nor the names
 *   of its contributors may be used to endorse or promote
 *   products derived from this software without specific
 *   prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * </pre>
 *
 */
class IPBlacklistFilter implements AlphaFilterInterface {

	/**
	 * Trace logger
	 *
	 * @var Logger
	 * @since 1.2
	 */
	private static $logger = null;

	/**
	 * Constructor
	 *
	 * @since 1.2
	 */
	public function __construct() {
		self::$logger = new Logger('IPBlacklistFilter');
	}

	/**
	 * (non-PHPdoc)
	 * @see alpha/util/filters/AlphaFilterInterface#process()
	 *
	 * @throws ResourceNotAllowedException
	 */
	public function process() {

		$ip = $_SERVER['REMOTE_ADDR'];

		if(!empty($ip)) {
			$badIP = new BlacklistedIPObject();

			try {
				$badIP->loadByAttribute('IP', $ip);
			}catch (BONotFoundException $bonf) {
				// ip is not on the list!
				return;
			}

			// if we got this far then the IP is bad
			self::$logger->warn('The IP ['.$ip.'] was blocked from accessing the resource ['.$_SERVER['REQUEST_URI'].']');
			throw new ResourceNotAllowedException('Not allowed!');
		}
	}
}

?>